<?php
    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: login.php");
        exit;
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add User</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body { font: 14px sans-serif; text-align: center; }
        .wrapper { width: 360px; padding: 20px; margin: auto; }
    </style>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const form = document.querySelector("form");
            form.addEventListener("submit", function(event) {
                const fields = ["username", "password", "qr_random", "email"];
                for (const field of fields) {
                    const input = document.getElementById(field);
                    if (!input.value.trim()) {
                        alert(`${field} is required.`);
                        event.preventDefault();
                        return;
                    }
                }
            });
        });
    </script>
</head>
<body>
    <div class="wrapper">
        <h2>Add User</h2>
        <form action="add_user_post.php" method="post">
            <div class="form-group">
                <label>Username</label>
                <input type="text" name="username" id="username" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" id="password" class="form-control" required>
            </div>
            <div class="form-group">
                <label>QR Random</label>
                <input type="text" name="qr_random" id="qr_random" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Email</label>
                <input type="email" name="email" id="email" class="form-control" required>
            </div>
            <div class="form-group">
                <input type="submit" value="Add User" name="submit" class="btn btn-primary btn-block">
            </div>
        </form>
    </div>
</body>
</html>
