<?php

require_once 'config.php'; // Include the database connection from config.php

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = trim($_POST['username']);
    $password = password_hash(trim($_POST['password']), PASSWORD_BCRYPT);
    $qr_random = trim($_POST['qr_random']);
    $email = trim($_POST['email']);

    if ($db->connect_error) {
        die("Connection failed: " . $db->connect_error);
    }

    $stmt = $db->prepare("INSERT INTO $ClientsTable (username, password, qr_random, email) VALUES (?, ?, ?, ?)");
    if ($stmt) {
        $stmt->bind_param("ssss", $username, $password, $qr_random, $email);
        if ($stmt->execute()) {
            echo "User added successfully.";
            $qr_code_url = "https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=" . urlencode($qr_random);
            echo '<br><img src="' . $qr_code_url . '" alt="QR Code">';
            echo '<br><a href="welcome.php">Go to Welcome Page</a>';
            echo '<br><a href="add-user.php">Add Another User</a>';
            exit;
        } else {
            if ($db->errno === 1062) { // Duplicate entry error code
                echo "Error: Duplicate entry for username, qr random or email.";
            } else {
                echo "Error: " . $db->error;
            }
        }
        $stmt->close();
    } else {
        echo "Error preparing statement: " . $db->error;
    }

    $db->close();
}
?>
