<?php
    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: login.php");
        exit;
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Firmware Upload</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body { font: 14px sans-serif; text-align: center; }
        .wrapper { width: 360px; padding: 20px; margin: auto; }
    </style>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const form = document.querySelector("form");
            form.addEventListener("submit", function(event) {
                const version = document.getElementById("version");
                const fileToUpload = document.getElementById("fileToUpload");
                if (!version.value.trim() || !fileToUpload.value.trim()) {
                    alert("All fields are required.");
                    event.preventDefault();
                }
            });
        });
    </script>
</head>
<body>
    <div class="wrapper">
        <h2>Firmware Upload</h2>
        <form action="firmware_upload_post.php" method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label>Firmware Version</label>
                <input type="number" value="1" name="version" id="version" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Type of Firmware</label>
                <select name="T" id="T" class="form-control" required>
                    <option value="Testing">Testing</option>
                    <option value="Production">Production</option>
                </select>
            </div>
            <div class="form-group">
                <label>Select Firmware Binary to Upload</label>
                <input type="file" name="fileToUpload" id="fileToUpload" class="form-control-file" required>
            </div>
            <div class="form-group">
                <input type="submit" value="Upload Firmware" name="submit" class="btn btn-primary btn-block">
            </div>
        </form>
    </div>
</body>
</html>
