<?php

$version = $_POST["version"];
$type = $_POST["T"];

$website_root = "http://rataaa.com/postbox/";
$json_file = "firmwares/firmware_status.json";
$target_dir = "firmwares/";
$target_file = $target_dir . basename($_FILES["fileToUpload"]["name"]);
$imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
$imageFileName = strtolower(pathinfo($target_file, PATHINFO_FILENAME));
$target_file = $target_dir . $imageFileName . "_" . $type . "_" . $version . "." . $imageFileType;
$uploadOk = 1;

$string = file_get_contents($json_file);
$json_a = json_decode($string, true);

// TODO: check if version is duplicate.
// Allow certain file formats
if (
  $imageFileType != "bin"
) {
  $err = "Only BIN files are allowed.\n";
  $uploadOk = 0;
}
// Check if $uploadOk is set to 0 by an error
if ($uploadOk == 0) {
  $err = "Your file was not uploaded.";
  // if everything is ok, try to upload file
} else {
  if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $target_file)) {
    $msg = "The file " . basename($_FILES["fileToUpload"]["name"]) . " has been uploaded.";

    // Update the json.
    if ($type == 'Production') {
      $json_a['firmware_version_prod'] = intval($version);
      $json_a['firmware_url_prod'] = $website_root . $target_file;
    } else {
      $json_a['firmware_version_test'] = intval($version);
      $json_a['firmware_url_test'] = $website_root . $target_file;
    }
    file_put_contents($json_file, json_encode($json_a));
  } else {
    $err = "There was an error uploading your file.";
  }
}
?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title>Login</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <style>
    body {
      font: 14px sans-serif;
    }

    .wrapper {
      width: 360px;
      padding: 20px;
    }
  </style>
</head>

<body>
  <?php
  if (!empty($err)) {
    echo '<div class="alert alert-danger">' . $err . '</div>';
  } else {
    echo '<div class="alert alert-success">' . $msg . '</div>';
  }
  ?>
  <p>
    <a href="firmware_upload.php" class="btn btn-danger ml-3">Upload a new Firmware</a>
    <a href="welcome.php" class="btn btn-danger ml-3">Return to Home</a>
  </p>
</body>

</html>