<?php
require_once 'config.php'; // Include the database connection

$username = trim($_POST['username']);

if ($db->connect_error) {
    die("Connection failed: " . $db->connect_error);
}

// Prepare the SELECT query to fetch qr_random for the given username
$stmt = $db->prepare("SELECT qr_random FROM $ClientsTable WHERE username = ?");
if ($stmt) {
    $stmt->bind_param("s", $username); // Bind the username parameter
    $stmt->execute(); // Execute the query
    $stmt->bind_result($qr_random); // Bind the result to $qr_random
    if ($stmt->fetch()) { // Fetch the result
        // Generate the QR code URL
        $qr_code_url = "https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=" . urlencode($qr_random);
        echo '<h3>QR Code for User: ' . htmlspecialchars($username) . '</h3>';
        echo '<br><img src="' . $qr_code_url . '" alt="QR Code">';
        echo '<br><a href="welcome.php">Go to Welcome Page</a>';
        echo '<br><a href="get-user-qr.php">Get Another User QR</a>';
    } else {
        echo "Error: No QR code found for the selected user.";
    }
    $stmt->close(); // Close the statement
} else {
    echo "Error: Could not prepare the query. " . $db->error;
}

$db->close(); // Close the database connection
?>