<?php
    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: login.php");
        exit;
    }

    // Include the database connection
    require_once 'config.php';

    // Fetch the user list from the database
    $users = [];
    $sql = "SELECT username FROM $ClientsTable WHERE mac = '' OR mac IS NULL ORDER BY username ASC";
    if ($result = $db->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $users[] = $row['username'];
        }
        $result->free();
    } else {
        die("ERROR: Could not fetch users. " . $db->error);
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Select User</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body { font: 14px sans-serif; text-align: center; }
        .wrapper { width: 360px; padding: 20px; margin: auto; }
    </style>
</head>
<body>
    <div class="wrapper">
        <h2>Select User</h2>
        <form action="get-user-qr-post.php" method="post">
            <div class="form-group">
                <label for="username">Select a User:</label>
                <select name="username" id="username" class="form-control" required>
                    <option value="">-- Select a User --</option>
                    <?php foreach ($users as $user): ?>
                        <option value="<?php echo htmlspecialchars($user); ?>"><?php echo htmlspecialchars($user); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <input type="submit" class="btn btn-primary" value="Submit">
            </div>
        </form>
    </div>
</body>
</html>