<?php

require_once 'config.php'; // Include the database connection from config.php

$mac = isset($_GET['mac']) ? $_GET['mac'] : null;

if ($mac) {
    if ($db->connect_error) {
        die("Connection failed: " . $db->connect_error);
    }

    $stmt = $db->prepare("SELECT fw_to_use, testing FROM $ClientsTable WHERE mac = ?");
    $stmt->bind_param("s", $mac);
    $stmt->execute();
    $stmt->bind_result($firmware, $testing);
    $stmt->fetch();
    $stmt->close();

    if ($firmware !== null) {
        $version = $firmware;
        $url = $testing ? 
            "esp32-postbox.ino.esp32s3_Testing_{$version}.bin" : 
            "esp32-postbox.ino.esp32s3_Production_{$version}.bin";
        
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['version' => $version, 'url' => $url]);
        exit;
    }
}

$json_file="firmwares/firmware_status.json";
$json = file_get_contents($json_file);
header('Content-Type: application/json; charset=utf-8');
echo $json;
