<?php

require_once "config.php";

// Define the days difference lookup as a constant
const DAYS_DIFFERENCE_LOOKUP = [
    "Monday" => 0,
    "Tuesday" => 1,
    "Wednesday" => 2,
    "Thursday" => 3,
    "Friday" => 4,
    "Saturday" => 5,
    "Sunday" => 6
];

// example of database data. (for debugging purposes)
/*$databaseData = '{
        "Monday": [1300,1700],
        "Tuesday": [1300,1700],
        "Wednesday": [1300,1700]
    }';*/

/**
 * Calculates the time interval in seconds until the next scheduled check based on the current time and the schedule stored in the database.
 *
 * @param string $mac The MAC address of the client.
 * @param mysqli $db The database connection object.
 * @return int The time interval in seconds until the next scheduled check.
 */
function getInterval($mac, $db)
{
    global $ClientsTable; // Add this line to import $ClientsTable

    $nextDayOfWeek = null;
    $nextDayTiming = null;
    $currentDayOfWeek = date('l'); // Get the current day of the week (e.g., Monday, Tuesday, etc.)
    $currentTimestamp = explode(':', date('h:i:s')); // Get the current time in the 'Hi' format

    $sql = "SELECT timing FROM $ClientsTable WHERE mac='$mac'";
    $queryResult = $db->query($sql);

    // Decode the JSON data into an associative array
    $queryResult = $queryResult->fetch_assoc();
    // check if the query result is empty
    if (is_null($queryResult) || !isset($queryResult['timing'])) {
        return 0; // TODO: how to handle this.
    }
    $scheduleData = json_decode($queryResult['timing'], true);

    $response["Current day of week"] = $currentDayOfWeek;
    $response["Current time"] = $currentTimestamp[0] . ":" . $currentTimestamp[1];

    // Find the next available day
    $daysOfWeek = array_keys($scheduleData);
    $currentDayIndex = array_search($currentDayOfWeek, $daysOfWeek);

    for ($i = $currentDayIndex; $i < $currentDayIndex + 7; $i++) {
        $nextDayIndex = $i % 7;
        $nextDay = $daysOfWeek[$nextDayIndex];

        if (isset($scheduleData[$nextDay])) {
            $nextDayOfWeek = $nextDay;
            $nextDayTiming = $scheduleData[$nextDay];
            break;
        }
    }
    $response["Next available day"]= $nextDayOfWeek;
    //find difference between current day and next day using the lookup table
    // $table = json_decode(DAYS_DIFFERENCE_LOOKUP, true);
    $nextDayIndex = DAYS_DIFFERENCE_LOOKUP[$nextDayOfWeek];
    $currentDayIndex = DAYS_DIFFERENCE_LOOKUP[$currentDayOfWeek];
    $daysDifference = ($nextDayIndex - $currentDayIndex);
    if ($daysDifference < 0) {
        $daysDifference += 7;
    }

    $nextTimeHours = $nextDayTiming[0] / 100;
    $nextTimeMinutes = $nextDayTiming[0] % 100;
    $differenceSeconds = null;
    //get the next time:
    if ($daysDifference == 0) {

        for ($i = 0; $i < count($nextDayTiming); $i++) {
            $nextTimeHours = $nextDayTiming[$i] / 100;
            $nextTimeMinutes = $nextDayTiming[$i] % 100;
            if (!($nextTimeHours > $currentTimestamp[0] && ($nextTimeHours == $currentTimestamp[0] && $nextTimeMinutes > $currentTimestamp[1]))) {
                break;
            }
        }
        $response["Next available time"]=$nextTimeHours . ":" . $nextTimeMinutes;
        $differenceHours = $nextTimeHours - $currentTimestamp[0];
        $differenceMinutes = ($nextTimeMinutes - $currentTimestamp[1]);
        if ($differenceMinutes < 0) {
            $differenceHours--;
            $differenceMinutes += 60;
        }
        $response["Difference in hours "] = $differenceHours;
        $response["Difference in minuetes"] = $differenceMinutes;
        $differenceSeconds = ($differenceHours * 60 + $differenceMinutes) * 60;
        $response["Difference in seconds"] =  $differenceSeconds;
    } else {
        $differenceSeconds = (($daysDifference - 1) * 24 * 60 * 60) + ($nextTimeHours * 60 * 60) + ($nextTimeMinutes * 60) +
            (24 - $currentTimestamp[0]) * 60 * 60 + (60 - $currentTimestamp[1]) * 60;
        $response["Difference in seconds"] =  $differenceSeconds;
    }
    return $differenceSeconds - $currentTimestamp[2];
}
?>