#!/home/rataaaco/local/bin/python3

import cv2 as cv
import numpy as np
import sys

# origin of the rectangle
x=0
y=0

# width and height of the rectangle
w=0
h=0

filename = sys.argv[1]

imga = cv.imread(filename)
if imga is None:
    sys.exit("Could not read the image.")

img = cv.resize(imga, (int(imga.shape[1]/4), int(imga.shape[0]/4)), interpolation = cv.INTER_AREA)
gray = cv.cvtColor(img, cv.COLOR_BGR2GRAY)

# make the high contrast edges more visible
gray = cv.convertScaleAbs(gray, 0.75, 4)
canny = cv.Canny(gray, 400, 450, 1)

cnts = cv.findContours(canny, cv.RETR_TREE, cv.CHAIN_APPROX_SIMPLE)
cnts = cnts[0] if len(cnts) == 2 else cnts[1]
# draw the contours
cv.drawContours(img, cnts, -1, (0, 255, 0), 2)

# draw a rectangle around the contours
for c in cnts:
    x,y,w,h = cv.boundingRect(c)
    cv.rectangle(img, (x, y), (x + w, y + h), (200,200,200), 2)

print(x,y,w,h)
