#!/home/rataaaco/local/bin/python3

import numpy as np
import cv2 as cv
import sys

ref = sys.argv[1]
refimg = cv.imread(ref)

filename = sys.argv[2]
img2 = cv.imread(filename)

# coordinates
x = int(sys.argv[3])
y = int(sys.argv[4])
w = int(sys.argv[5])
h = int(sys.argv[6])

# lower the resolution of both images
refimg = cv.resize(refimg, (int(refimg.shape[1]/4), int(refimg.shape[0]/4)), interpolation = cv.INTER_AREA)
img2 = cv.resize(img2, (int(img2.shape[1]/4), int(img2.shape[0]/4)), interpolation = cv.INTER_AREA)

# find the difference between the two images
diff = cv.absdiff(refimg, img2)
# exclude the rectangle region found by contour above
diff[y:y+h, x:x+w] = 0
# if there is difference in the image, it will be white
diff = cv.cvtColor(diff, cv.COLOR_BGR2GRAY)
diff = cv.convertScaleAbs(diff, 0.75, 4)
diff = cv.Canny(diff, 400, 450, 1)
flag = False
# if there is a white pixel in the image, it means there is a difference and flag should be True
for i in range(diff.shape[0]):
    for j in range(diff.shape[1]):
        if diff[i][j] == 255:
            flag = True
            break
    if flag:
        break

if flag == True:
    print("1")
else:
    print("0")
# print(flag)
#display diff
# cv.imshow("diff", diff)
# cv.waitKey(0)