#!/bin/bash

# Get the script directory
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

REF_IMG="$DIR/../sample_images/inside_withflash.jpg"
IMG2="$DIR/../sample_images/inside_with_letter.jpg"
QR_IMG="$DIR/../sample_images/frame.png"

echo "Testing QR Script..."
QR_CODE=$(LD_LIBRARY_PATH=/home/rataaaco/local/lib/ $DIR/../readQR.py $QR_IMG)
if [ -z $QR_CODE ];then
    echo "error reading QR code"
else
    echo "QR value: $QR_CODE"
    if [[ $QR_CODE = "abcd1234" ]];then
        echo "Test passed"
    else
        echo "Expected=abcd1234, Got $QR_CODE"
    fi
fi

echo "Testing center square script..."
COORDINATES=$($DIR/../getCenterSq.py $REF_IMG)
# COORDINATES contains 4 values separated by spaces
# check if these are valid or not
if [ -z "$COORDINATES" ];then
    echo "error reading coordinates"
else
    echo "Coordinates: $COORDINATES"
    if [[ "$COORDINATES" = "304 193 169 212" ]];then
        echo "Test passed"
    else
        echo "Expected=304 193 169 212, Got: $COORDINATES"
    fi
fi

echo "Testing difference script..."
DIFF=$($DIR/../readDiff2.py $REF_IMG $IMG2 304 193 169 212)
if [ -z $DIFF ];then
    echo "error getting diff"
else
    echo "Diff: $DIFF"
    if [[ $DIFF = "1" ]];then
        echo "Test passed"
    else
        echo "Test failed"
    fi
fi
