<?php
    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: login.php");
        exit;
    }

    require_once "config.php";

    $username = $_SESSION["username"];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Update Settings</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body { font: 14px sans-serif; text-align: center; }
        .wrapper { width: 360px; padding: 20px; margin: auto; }
    </style>
</head>
<body>
    <div class="wrapper">
        <h2>Update Settings</h2>
        <form action="settings.php" method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label for="T">Mode</label>
                <select name="T" id="T" class="form-control">
                    <option value="1">Testing</option>
                    <option value="0">Production</option>
                </select>
            </div>
            <div class="form-group">
                <label for="cc">Continuous Check</label>
                <select name="cc" id="cc" class="form-control">
                    <option value="0">Off</option>
                    <option value="1">On</option>
                </select>
            </div>
            <div class="form-group">
                <label for="heartbeat">Heartbeat (hrs)</label>
                <input type="number" name="heartbeat" id="heartbeat" value="240" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="door_wait">Door Wait (secs)</label>
                <input type="number" name="door_wait" id="door_wait" value="5" class="form-control" required>
            </div>
            <input type="hidden" name="username" value="<?php echo $username; ?>">
            <div class="form-group">
                <input type="submit" value="Update Settings" name="submit" class="btn btn-primary btn-block">
            </div>
        </form>
    </div>
</body>
</html>
