<?php
// Code Based on this example: w3schools.com/php/php_file_upload.asp

$website_root = "http://rataaa.com/postbox/";

$mac = $_POST["uid"];
$battery_level = $_POST["bat"];

$target_dir = "uploads/$mac/";
$datum = mktime(date('H') + 0, date('i'), date('s'), date('m'), date('d'), date('y'));
$target_file = $target_dir . date('Y.m.d_H_i_s_', $datum) . basename($_FILES["imageFile"]["name"]);
$uploadOk = 1;
$imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
$response = ["target_file" => $target_file];

$ScriptQR = "python/readQR.py";
$ScriptCentSq = "python/getCenterSq.py";
$ScriptDiff = "python/readDiff2.py";

// TODO: battery debugging.
$battery_file = "uploads/$mac/battery";
file_put_contents($battery_file, $battery_level);

require_once "config.php";
require_once "interval.php";

// if $mac is empty, return an error.
if ($mac == null || $mac == "") {
    sendResponse(["error" => "Empty mac"], 400);
}

// Create the directory if it doesn't exist.
if (!file_exists($target_dir)) {
    mkdir($target_dir, 0777, true);
}

// Check if image file is an actual image or fake image
if (isset($_POST["submit"])) {
    $check = getimagesize($_FILES["imageFile"]["tmp_name"]);
    if ($check === false) {
        $response["error"] = "File is not an image.";
        $uploadOk = 0;
    }
}

// Check if file already exists
if (file_exists($target_file)) {
    $response["error"] = "Sorry, file already exists.";
    $uploadOk = 0;
}

// Check file size
if ($_FILES["imageFile"]["size"] > 800000) {
    $response["error"] = "Sorry, your file is too large.";
    $uploadOk = 0;
}

// Allow certain file formats
$allowedFileTypes = ["jpg", "png", "jpeg", "gif"];
if (!in_array($imageFileType, $allowedFileTypes)) {
    $response["error"] = "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
    $uploadOk = 0;
}

// Check if uid exists.
$sql = "SELECT * FROM $ClientsTable WHERE mac = '$mac'";
$result = $db->query($sql);

// When a new device wants to register, it must provide a valid QR code.
if ($result->num_rows == 0) {
    if ($uploadOk && move_uploaded_file($_FILES["imageFile"]["tmp_name"], $target_file)) {
        $response["message"] = "received new mac: $mac";
        $cmd = "LD_LIBRARY_PATH=/home/rataaaco/local/lib/ $ScriptQR $target_file";
        $output = shell_exec($cmd);
        if ($output === false || $output === null) {
            $response["error"] = "Unable to detect QR";
            unlink($target_file);
            sendResponse($response, 400);
        }

        $output = str_replace(["\n", "\r"], '', $output);
        $response["QR"] = $output;

        $sql = "SELECT * FROM $ClientsTable WHERE qr_random = '$output'";
        $result = $db->query($sql);
        if ($result->num_rows == 0) {
            $response["error"] = "QR does not exist";
            sendResponse($response, 400);
        } elseif ($result->num_rows > 1) {
            sendResponse(["error" => "Invalid QR query"], 400);
        }

        // TODO: delete QR file after use
        // unlink($target_file);

        $username = mysqli_fetch_assoc($result)["username"];
        $response["device_owner"] = $username;

        $sql = "UPDATE $ClientsTable SET mac='$mac' WHERE username='$username'";
        $response["operation"] = "Update record from QR";
        if ($db->query($sql) === TRUE) {
            $response["msg"] = "Record updated successfully";
        } else {
            $response["error"] = "Error: " . $sql . "<br>" . $db->error;
        }
        sendResponse($response);
    } else {
        sendResponse(["error" => "Unable to read the QR file"], 500);
    }
} elseif ($result->num_rows > 1) {
    sendResponse(["error" => "Invalid Device id query"], 400);
}

$settings = mysqli_fetch_assoc($result);
$username = $settings["username"];
$refImg = $settings["ref_img"];
$coords_valid = !($settings["center_square_x"] == 0 || $settings["center_square_y"] == 0 || $settings["center_square_w"] == 0 || $settings["center_square_h"] == 0);
$email = $settings["email"];

if ($battery_level < 20) {
    $response["battery_status"] = "low";
    $msg = "Hi $username,\n\nThe battery level on your postbox is low. Please charge immediately.\n";
    // TODO: temporarily disable email.
    // mail($email, "Postbox battery low", $msg);
} else {
    $response["battery_status"] = "normal";
}

if ($uploadOk == 0) {
    $response["error"] = "Sorry, your file was not uploaded.";
} else {
    if (move_uploaded_file($_FILES["imageFile"]["tmp_name"], $target_file)) {
        $response["uploaded"] = "The file " . basename($_FILES["imageFile"]["name"]) . " has been uploaded.";

        if ($refImg == null || $refImg == "" || !file_exists($refImg) || !$coords_valid) {
            $response["operation"] = "Update reference image";
            $sql = "UPDATE $ClientsTable SET ref_img='$target_file' WHERE mac='$mac'";
            if ($db->query($sql) === TRUE) {
                $response["msg"] = "Reference image updated successfully";
                $cmd = "$ScriptCentSq $target_file";
                $output = shell_exec($cmd);
                if ($output === false || $output === null) {
                    sendResponse(["error" => "Unable to detect center square"], 400);
                }

                $coords = explode(" ", $output);
                $origin_x = $coords[0];
                $origin_y = $coords[1];
                $width = $coords[2];
                $height = $coords[3];

                $sql = "UPDATE $ClientsTable SET 
                    center_square_x='$origin_x', 
                    center_square_y='$origin_y',
                    center_square_w='$width', 
                    center_square_h='$height' 
                    WHERE mac='$mac'";
                if ($db->query($sql) === TRUE) {
                    $response["msg2"] = "Co-ordinates updated successfully";
                    $response['x'] = $origin_x;
                    $response['y'] = $origin_y;
                    $response['w'] = $width;
                    $response['h'] = $height;
                } else {
                    $response["error"] = "Unable to put co-ordinates into table";
                    sendResponse($response, 400);
                }
                sendResponse($response);
            } else {
                $response["error"] = "Error: " . $sql . "<br>" . $db->error;
            }
        } else {
            $response["operation"] = "Image upload";
            $cmd = "$ScriptDiff $refImg $target_file {$settings['center_square_x']} {$settings['center_square_y']} {$settings['center_square_w']} {$settings['center_square_h']}";
            $output = shell_exec($cmd);
            if ($output === false || $output === null) {
                $response["error"] = "Error running change detection script";
                // TODO: only for debugging
                $response["cmd"] = $cmd;
                sendResponse($response, 500);
            }

            if ($output == "0") {
                $response["change_detected"] = 0;
                // Uncomment the following lines to enable file deletion
                // $sql = "SELECT latest_key FROM $ClientsTable WHERE mac='$mac'";
                // $query = $db->query($sql);
                // if (file_exists($query)) {
                //     if (unlink($query)) {
                //         echo "File deleted successfully.";
                //     } else {
                //         echo "Error deleting the file.";
                //     }
                // } else {
                //     echo "File does not exist.";
                // }
                // unlink($target_file);
            } else {
                $response["change_detected"] = 1;
                $msg = "Hi $username,\n\nA new mail detected was detected in your mailbox.\nCheck here: $website_root$target_file \n";
                mail($email, "Postbox change detected", $msg);
                $sql = "UPDATE $ClientsTable SET 
                    latest_image='$target_file', 
                    latest_image_time=now()
                    WHERE mac='$mac'";
                $db->query($sql);
            }
            // send time for next image.
            // TODO. calculate next check and also put it in database.
            // We have a 'plan' in the database for the number of checks.
            // and 'timing' which is a json with the list of days when
            // we should check and the times. e.g. check between 9-5 pm.
            // database has a next_check where the timestamp should be placed
            // for next check. photo_interval in the database is the difference
            // between now() and next_check and this will be sent to the
            // ESP32 since it needs the amount of time in ms to sleep and 
            // not a timestamp to wake.
            // TODO: next_check should be unique in database
            $intervalInSeconds = getInterval($mac, $db);
            $response["next_check"] = $intervalInSeconds;
        }
    } else {
        $response["msg"] = "Sorry, there was an error uploading your file.";
    }
    sendResponse($response);
}

function sendResponse($response, $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($response);
    exit();
}
