<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}

require_once 'config.php'; // Include the database connection

$mac = null;
if ($db->connect_error) {
    die("Connection failed: " . $db->connect_error);
}

$stmt = $db->prepare("SELECT mac FROM $ClientsTable WHERE username = ?");
$stmt->bind_param("s", $_SESSION["username"]);
$stmt->execute();
$stmt->bind_result($mac);
$stmt->fetch();
$stmt->close();
?>
 
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Welcome</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body{ font: 14px sans-serif; text-align: center; }
    </style>
</head>
<body>
    <h1 class="my-5">Hi, <b><?php echo htmlspecialchars($_SESSION["username"]); ?></b>.</h1>
    <p>
        <a href="firmware_upload.php" class="btn btn-danger ml-3">Upload a new Firmware</a>
        <a href="settings_update.php" class="btn btn-danger ml-3">Update your ESP settings</a>
        <?php if ($_SESSION["username"] === "admin"): ?>
            <a href="add-user.php" class="btn btn-danger ml-3">Add User</a>
            <a href="get-user-qr.php" class="btn btn-danger ml-3">Get User QR</a>
        <?php endif; ?>
        <a href="logout.php" class="btn btn-danger ml-3">Sign Out of Your Account</a>
    </p>
    <p>
        <?php if ($mac): ?>
            Device assigned: <b><?php echo htmlspecialchars($mac); ?></b>
        <?php else: ?>
            No device assigned
        <?php endif; ?>
    </p>
</body>
</html>